"""2-D lattice geometry (minimal helpers)."""
from __future__ import annotations
from dataclasses import dataclass

@dataclass
class Lattice:
    Lx: int
    Ly: int
    y_slit: int
    slit_halfwidth: int
    slit_offset: int
    y_meter: int
    screen_y: int

    @property
    def x_center(self) -> int:
        return self.Lx // 2

    def slit_columns(self):
        cl = self.x_center - self.slit_offset
        cr = self.x_center + self.slit_offset
        return cl, cr

    def in_slit(self, x: int) -> bool:
        cl, cr = self.slit_columns()
        return (abs(x - cl) <= self.slit_halfwidth) or (abs(x - cr) <= self.slit_halfwidth)
